/* ---------------------------------------------------------------------- */
/*	Theme Settings														  */
/* ---------------------------------------------------------------------- */

	/* ---------------------------------------------------- */
	/*	Menu												*/
	/* ---------------------------------------------------- */

	var objNavMenu = {
		fixed: true // Boolean:  (true/false)
	};

	/* ---------------------------------------------------- */
	/*	Flickr											    */
	/* ---------------------------------------------------- */

	var objFlickr = {
		limit: 6, // Max 9
		qstrings: {id : '54958895@N06'}, // ID
		itemTemplate: '<li><a class="badge" target="_blank" href="{{image_b}}" href="#"><img src="{{image_s}}" alt="{{title}}" /></a></li>'
	};

	/* ---------------------------------------------------- */
	/*	Google Map											*/
	/* ---------------------------------------------------- */

	var objGoogleMap = {
		address: 'New York, USA', // City, County
		markers: [
			{'address' : 'Grand St, New York'} // Street
		],
		zoom: 14 // 0 - 21
	};

	/* ---------------------------------------------------- */
	/*	Layer Slider										*/
	/* ---------------------------------------------------- */

	var objLayerSlider = {
		width : '100%',						
		height : '400px',
		responsive : true,					// Boolean:  (true/false)
		responsiveUnder : 940,
		sublayerContainer : 940,
		autoStart : true,					// Boolean:  If true, slideshow will automatically start after loading the page. (true/false)
		pauseOnHover : true,				// Boolean: If ture, SlideShow will pause when you move the mouse pointer over the LayerSlider container. (true/false)
		firstLayer : 1,						// Integer:  LayerSlider will begin with this layer. (Positive Integer)
		animateFirstLayer : true,			// Boolean:  (true/false)
		randomSlideshow : false,			// Boolean:  (true/false)
		twoWaySlideshow : true,				// Boolean: If true, slideshow will go backwards if you click the prev button. (true/false)
		loops : 0,
		forceLoopNum : true,				// Boolean:  (true/false)
		autoPlayVideos : false,				// Boolean:  (true/false)
		autoPauseSlideshow : 'auto',
		keybNav : true,						 // Boolean: Keyboard navigation. You can navigate with the left and right arrow keys. (true/false)
		touchNav : true,					 // Boolean:  (true/false)
		skin : 'goodnex',					 // String: You can change the skin of the Slider. (name_of_the_skin) 
		skinsPath : 'js/layerslider/skins/', // String: You can change the default path of the skins folder. Note, that you must use the slash at the end of the path. (path_of_the_skins_folder/)
		showBarTimer : false,				 // Boolean:  (true/false)
		showCircleTimer : false,			 // Boolean:  (true/false)
		globalBGColor : '#f6f6f6',			 // CSS Color Methods. Background color of LayerSlider. You can use all CSS methods, like hexa colors, rgb(r,g,b) method, color names, etc. Note, that background sublayers are covering the background. 
		navPrevNext : true,					 // Boolean: If false, Prev and Next buttons will be invisible. (true/false)
		navStartStop : false,				 // Boolean: If false, Start and Stop buttons will be invisible. (true/false)
		navButtons : false,					 // Boolean: If false, slide buttons will be invisible. (true/false)
		hoverPrevNext : true,				 // Boolean:  (true/false)
		hoverBottomNav : false,				 // Boolean:  (true/false)
		thumbnailNavigation : 'disabled',
		tnWidth : 100,
		tnHeight : 60,
		tnContainerWidth : '60%',
		tnActiveOpacity : 35,
		tnInactiveOpacity : 100
	};

	/* ---------------------------------------------------- */
	/*	Flex Slider											*/
	/* ---------------------------------------------------- */

	var objFlexSlider = {
		animation: "slide",			// String: Select your animation type, "fade" or "slide"
		easing: "swing",			// Refer to the link below  http://easings.net/
		direction: "horizontal",    // String: Select the sliding direction, "horizontal" or "vertical"
		controlNav: false,			// Boolean: Create navigation for paging control of each clide? Note: Leave true for manualControls usage
		directionNav: true,			// Boolean: Create navigation for previous/next navigation? (true/false)
		slideshowSpeed: 6000,		// Integer: Set the speed of the slideshow cycling, in milliseconds
		animationSpeed: 600,        // Integer: Set the speed of animations, in milliseconds
		randomize: false            // Boolean: Randomize slide order
	};

	/* ---------------------------------------------------- */
	/*	Carousel											*/
	/* ---------------------------------------------------- */

	var jCarousel = {
		animation: 600,
		easing: 'easeOutCubic' // Refer to the link below  http://easings.net/
	};

	/* ---------------------------------------------------- */
	/*	Image Post Slider									*/
	/* ---------------------------------------------------- */

	var objPostSlider = {
		easing: 'easeInOutExpo', // Refer to the link below  http://easings.net/
		speed: 600,
		timeout: 5000
	};

	/* ---------------------------------------------------- */
	/*	Image Gallery Slider								*/
	/* ---------------------------------------------------- */

	var objGallerySlider = {
		easing: 'easeInOutExpo', // Refer to the link below  http://easings.net/
		speed: 600,
		timeout: 5000
	};

	/* ---------------------------------------------------- */
	/*	Testimonials										*/
	/* ---------------------------------------------------- */

	var objTestimonials  = {
		easing: 'easeInOutExpo', // Refer to the link below  http://easings.net/
		speed: 600,
		timeout: 5000
	};

	/* ---------------------------------------------------- */
	/*	Black And White										*/
	/* ---------------------------------------------------- */

	var objBlackAndWhite  = {
		hoverEffect: true, // default true
		// set the path to BnWWorker.js for a superfast implementation
		webworkerPath: '',
		// for the images with a fluid width and height 
		responsive: true,
		invertHoverEffect: false,
		speed: {//this property could also be just speed: value for both fadeIn and fadeOut
			fadeIn: 400, // 400ms for fadeIn animations
			fadeOut: 800 // 800ms for fadeOut animations
		}
	};
	
/* ---------------------------------------------------------------------- */
/*	end Theme Settings													  */
/* ---------------------------------------------------------------------- */			
		
/* ---------------------------------------------------- */
/*	Login JS										*/
/* ---------------------------------------------------- */

	function convertIntoSHA256(pwd)
	{
		if((document.login.isSHA256Appld.value)=="true")
		{
			var pwdVal = document.getElementById( pwd ).value;
			if( checkNull( pwdVal ).length > 0  )
			{
				pwdVal = sha256_digest( pwdVal );
				document.login.PASSWORD.value=pwdVal;
			}
		}
	}

	function checkNull(val)
	{
		var passVal = val + "";
		if( passVal == null || passVal == undefined || passVal === "undefined")
		{
			passVal = "";
		}
		return passVal;
	}

	function forgotPassword()
	{
		var user = document.getElementById('id_user');
		var userName = user ? user.value : '';
		if(userName == null || userName == '' || userName == 'undefined')
		{
		    alert("User ID can not be left blank.");
		    return false;
		}
		window.location.href = '/ibase/AuthenticateServlet?action=FORGOTPASSWORD&USER=' + userName;
	}
	
	
	
	
//Added by Ankush S. on 25-SEP-2023 [For send and verify OTP]START
let verifyOTP = false;
function sendOTP() {

	if (verifyOTP) {
		//loginViaOTP();

		
		var mobile = document.getElementById('id_user');
		var mobileNo = mobile ? mobile.value : '';

		if (mobileNo == null || mobileNo == '' || mobileNo == 'undefined') {
			alert("Mobile Number can not be left blank.");
			verifyOTP = true;
			return;
		}
		var otp = document.getElementById('id_password');
		var otp_val = otp ? otp.value : '';

		if (otp_val == null || otp_val == '' || otp_val == 'undefined') {
			alert("OTP can not be left blank.");
			verifyOTP = true;
			return;
		}


		//alert("verifying otp");
		const servletUrl = "/ibase/AuthenticateServlet";
		var MAC_ADDRESS = document.getElementById('MAC_ADDRESS').value;
		const params = new URLSearchParams();
		params.append('action', 'LOGIN_VIA_OTP');
		params.append('MOBILE_NO', mobileNo);
		params.append('OTP', otp_val);
		params.append('MAC_ADDRESS', MAC_ADDRESS);

		fetch(servletUrl, {
			method: 'POST',
			headers: { 'Content-Type': 'application/x-www-form-urlencoded', },
			body: params,
		})
			.then(response => {
				if (!response.ok) {
					throw new Error('Network response was not ok');
				}
				return response.json();
			})
			.then(data => {
				console.log(data);
				if (data.success) {
					console.log('Success:', data.success);

					hideCountdown();

					//alert(data.success);
					loginViaOTP(data.userCode,data.password);
				} else if (data.error) {
					//displayCountdown();
					console.error('Error:', data.error);
					verifyOTP = true;
					alert(data.error);
				} 
				else {
					verifyOTP = true;
					console.error('Unexpected response:', data);
				}
			})
			.catch(error => {
				console.error('Error:', error);
			});

		return;
	}
	else {
		//alert("sendingotp");

		var mobileNoInput = document.getElementById('id_user');
		var mobileNo = mobileNoInput ? mobileNoInput.value : '';

		if (mobileNo == null || mobileNo == '' || mobileNo == 'undefined') {
			alert("Mobile Number can not be left blank.");
			return false;
		}
		const servletUrl = "/ibase/AuthenticateServlet";
		const params = new URLSearchParams();
		params.append('action', 'SEND_OTP');
		params.append('MOBILE_NO', mobileNo);
		fetch(servletUrl, {
			method: 'POST',
			headers: { 'Content-Type': 'application/x-www-form-urlencoded', },
			body: params,
		})
			.then(response => {
				if (!response.ok) {
					throw new Error('Network response was not ok');
				}
				return response.json();
			})
			.then(data => {
				if (data.success) {
					console.log('Success:', data.success);
					verifyOTP = true;
					displayCountdown();
					alert(data.success);
				} else if (data.error) {
					//displayCountdown();
					console.error('Error:', data.error);
					alert(data.error);
				} else {
					console.error('Unexpected response:', data);
				}
			})
			.catch(error => {
				console.error('Error:', error);
			});
	}
	
}
//Added by Ankush S. on 25-SEP-2023 [For send and verify OTP]END
//Added by Ankush S. on 25-SEP-2023 [For hide OTP expire time]START
function hideCountdown() {
	const forgotPasswordLink = document.querySelector('.login_forgot_href');
	forgotPasswordLink.style.display = 'block';

	const otpTimerElement = document.getElementById('otp-time');
	otpTimerElement.style.display = 'none';

	const passwordLabel = document.querySelector(".lbl-password");
	passwordLabel.textContent = "Password";

	const loginButton = document.querySelector(".login_button");
	loginButton.style.display = "block";

}
//Added by Ankush S. on 25-SEP-2023 [For hide OTP expire time]END
//Added by Ankush S. on 25-SEP-2023 [For show OTP expire time]START
function displayCountdown() {
	const forgotPasswordLink = document.querySelector('.login_forgot_href');
	forgotPasswordLink.style.display = 'none';

	const otpTimerElement = document.getElementById('otp-time');
	otpTimerElement.style.display = 'block';

	const passwordLabel = document.querySelector(".lbl-password");
	passwordLabel.textContent = "OTP";

	const loginButton = document.querySelector(".login_button");
	loginButton.style.display = "none";

	const otpButton = document.getElementById("otp-button");
	otpButton.textContent = "Verify";

	const resendOTPLink = document.getElementById("resend_otp");
	resendOTPLink.style.display = "none";
	verifyOTP = true;
	let timeLeft = 5 * 60;
	const timerInterval = setInterval(() => {
		const minutes = Math.floor(timeLeft / 60);
		const seconds = timeLeft % 60;
		otpTimerElement.textContent = `OTP Expire in ${minutes}:${seconds < 10 ? '0' : ''}${seconds}`;
		timeLeft -= 1;

		if (timeLeft < 0) {
			clearInterval(timerInterval);
			otpTimerElement.textContent = '';
			verifyOTP = false;
			console.log("time left ", timeLeft);

			resendOTPLink.style.display = "block";
		}

	}, 1000);
}
//Added by Ankush S. on 25-SEP-2023 [For show OTP expire time]END
//Added by Ankush S. on 04-OCT-2023 [For call Authenticate servlet]START
function loginViaOTP(user,password) {
	
	var loginForm = document.forms['login'];
	console.log(loginForm);
	var formData = new FormData(loginForm);
	//formData.append('PASSWORD', password);
	loginForm.elements['PASSWORD'].value = password;
	loginForm.elements['USER'].value = user;
	//formData.append('USER', user);
	for (var pair of formData.entries()) {
		console.log(pair[0] + ', ' + pair[1]);
	}
	loginForm.submit();
	
}
//Added by Ankush S. on 04-OCT-2023 [For call Authenticate servlet]END


/* ---------------------------------------------------- */

